'*****************************************************
' This is a sample VBScript to demonstrate the ActiveX
' capabilities of the BootManage Administrator.
'
' Within all functions, the RemoteServer parameter
' specifies the machine on which the component is
' executed. It defaults to "localhost", but can be
' replaced with the computername of a different machine.
'*****************************************************


'*****************************************************
' Get Client Property
'
' Samples:
' Get MAC address of a clinet named "PC22"
' GetClientProperty("Name", "PC22" ,"MAC")
'*****************************************************
Function GetClientProperty(ConditionField,ConditionValue,ReturnField)
  Dim objActiveXServer
  Dim RemoteServer
  Dim sBuffer
  Dim l

  RemoteServer = "localhost"
  Set objActiveXServer = CreateObject("BMA_Server.clsGetData", RemoteServer)
  l = objActiveXServer.GetClientProperty(ConditionField,ConditionValue,ReturnField,sBuffer)
  If l <> 0 Then
     MsgBox "Fehler: " & GetErrorString(l)
  End If
  Set objActiveXServer = Nothing
  GetClientProperty = sBuffer
End Function

'*****************************************************
' Send Wake-on-LAN Packet
'
' Send a Wakeup Packet to the client computer with the
' MAC address "strMAC". The client must reside
' within the same subnet.
'
'*****************************************************
Function WakeOnLan(strMAC)
  Dim objActiveXServer
  Dim l
  Dim RemoteServer
  Dim msg
  
  RemoteServer = "localhost"
  
  Set objActiveXServer = CreateObject("BMA_Server.clsNetwork", RemoteServer)
  l = objActiveXServer.SendWakeOnLan(strMAC)
  If l <> 0 Then
     MsgBox "Error: " & GetErrorString(l)
  End If
  Set objActiveXServer = Nothing
End Function



'*****************************************************
' Send Wake-on-WAN Packet
'
' Send a Wakeup Packet to the client computer with the
' MAC address "strMAC". The client can reside
' within the same or a different subnet.
'
'*****************************************************
Function WakeOnWan(strMAC)
  Dim objActiveXServer
  Dim sClientMacAddress
  Dim l
  Dim RemoteServer
  Dim msg
  
  RemoteServer = "localhost"
  sClientMacAddress = "" 
  
  Set objActiveXServer = CreateObject("BMA_Server.clsNetwork", RemoteServer)
  l = objActiveXServer.SendWakeOnWAN(strMAC)
  If l <> 0 Then
     MsgBox "Error: " & GetErrorString(l)
  End If
  Set objActiveXServer = Nothing
End Function


'*****************************************************
' Error Strings
'*****************************************************
Function GetErrorString(ErrorNumber)
  Select Case ErrorNumber
  Case 10
    GetErrorString = "INVALID_TFTPBOOT"
  Case 20
    GetErrorString = "INVALID_MAC"
  Case 21
    GetErrorString = "INVALID_NAME"
  Case 22
    GetErrorString = "INVALID_CLIENT_PARAM"
  Case 25
    GetErrorString = "INVALID_SERVERNAME"
  Case 40
    GetErrorString = "INVALID_OS"
  Case 41
    GetErrorString = "INVALID_OS_PARAM"
  Case 50
    GetErrorString = "INVALID_BMISTRUCT"
  Case 150
    GetErrorString = "INVALID_DATABASE"
  Case 151
    GetErrorString = "NO_DATA_FOUND"
  Case 100
    GetErrorString = "ERROR_WRITE_FILE"
  Case 1000
    GetErrorString = "ERROR_LICENSE"
  Case 1001
    GetErrorString = "ERROR_DEFAULT_PARAM"
  Case Else   ' Andere Werte.
     GetErrorString = CStr(ErrorNumber)
  End Select

End Function


'*****************************************************
' Main Routine
'*****************************************************

  strClientName="Harry"
  strMAC=GetClientProperty("name",strClientName,"mac")
  MsgBox  "Send WOL / WOW to " & strMAC

  WakeOnLan strMAC
  WakeOnWan strMAC
  MsgBox  "VBS Script finished"
